 /*
   *  Object %name    : %
   *  State           :  %state%
   *  Creation date   :   Apr 05 12:09:38 2009
   *  Last modified   :  %modify_time%
   */
  /** @file
   *  \brief A brief description of this module
   *
   *  \version  SST_Ext_ATP_Utility.c#1:csrc:1
   *  \author   taniam
   *  \remarks Copyright (C) 2007 by Discretix Technologies Ltd.
   *           All Rights reserved
   */

/************* Include Files ***********************************/

#include "SST_Ext_ATP_Utility.h"
#include "ExtApp_HOST_TST_Message.h"
#include "MW_ATP_UTIL_funcs.h"
#include "NVS.h"
#include "SST_EXT_TST.h"
#include "SST_Ext_ATP_Data.h"


 #if TST_USE_SST_UTIL_MODULE

/************************ Global Data **************************/
extern DxError_t      EXT_TST_ATP_Error;
extern DxUint8_t      EXT_FailureFunctionNameOut[TST_FUNC_STRING_LEN];
extern DxError_t      EXT_TST_TestStatus;
extern DxChar         TST_Ext_MainDBPool[NVS_MEMORY_DATA_POOL_SIZE_IN_BYTES];
extern DxChar         TST_Ext_SecondaryDBPool[NVS_MEMORY_DATA_POOL_SIZE_IN_BYTES];
extern DxVosFile      TST_Ext_MainDBFileHandle;
extern DxVosFile      TST_Ext_SecondaryDBFileHandle;
extern Ext_ATP_DataOpTestDataStruct SEP_ATP_DataOpTestData[];


/*****************************************************************************
 * Function Name:                                                           
 *  SST_Ext_ATP_UtilityHandle      
 * 
 * Inputs:
 *  None
 *
 * Outputs:
 *  DxError_t - Function error return                                        
 *
 * Description:                                                                 
 *   Test the iteration services  begin, increment and get, decrement and get, 
 *       get all handles and terminate operations.
 *  
 * Algorithm:       
 *    1.    Call to HOSTQA_ATP_Message function
 *
 *******************************************************************************/ 
 
 
 DxError_t SST_Ext_ATP_UtilityHandle(  )
 {
  
    /********* TST Variables Definitions ************/
    char                        TST_MasterTestName[TST_FUNC_STRING_LEN] = "SST_Ext_ATP_UtilityHandle";
    /********* TST Variables initialization *********/
    EXT_TST_TestStatus = TESTPASS;

    /************************************************/
    /*********** Start of test **********************/
    /************************************************/
	
	ATP_LOG_TST_PRINT((SST_TST_MSG,"\n",TST_MasterTestName,"\n"));

	EXT_TST_ATP_Error = HOSTQA_ATP_Message (DX_SEP_HOST_SEP_PROTOCOL_SST_Utility_Handle_OP_CODE,sizeof(Ext_ATP_DataOpTestDataStruct),SEP_ATP_DataOpTestData);
													 
	EXT_TST_TestStatus = TST_ATP_CheckErrorReturn(EXT_TST_ATP_Error,"SST_Ext_ATP_UtilityHandle", 
		                                           "HOSTQA_ATP_Message",TST_MasterTestName);											
    
	return EXT_TST_TestStatus;												                        
 }
 
 /*****************************************************************************
 * Function Name:                                                           
 *  SST_Ext_ATP_UtilitySize      
 * 
 * Inputs:
 *  None
 *
 * Outputs:
 *  DxError_t - Function error return                                        
 *
 * Description:                                                                 
 *   Test the iteration services  begin, increment and get, decrement and get, 
 *       get all handles and terminate operations.
 *  
 * Algorithm:       
 *    1.    Call to HOSTQA_ATP_Message function
 *
 *******************************************************************************/ 
 
 
 DxError_t SST_Ext_ATP_UtilitySize(  )
 {
 
    /********* TST Variables Definitions ************/
    char                        TST_MasterTestName[TST_FUNC_STRING_LEN] = "SST_Ext_ATP_UtilitySize";
    //DxNvsMemoryId_t             nvsMemoryId;
    SSTInitInfo_t               aInitInfo;
    DxUint32_t                  TST_maxSizeInBytesMain;
    DxUint32_t                  TST_CurrUsedSizeInBytesMain;
    DxUint32_t                  TST_maxSizeInBytesTxn;
    DxUint32_t                  TST_CurrUsedSizeInBytesTxnLast;
 
    /********* TST Variables initialization *********/
    EXT_TST_TestStatus = TESTPASS;

    /************************************************/
    /*********** Start of test **********************/
    /************************************************/
	
	ATP_LOG_TST_PRINT((SST_TST_MSG,"\n",TST_MasterTestName,"\n"));
	
	
	
	/* Terminate the SST */
    /*-------------------*/
    EXT_TST_ATP_Error = SST_Terminate();

    EXT_TST_TestStatus = TST_ATP_CheckErrorReturn(EXT_TST_ATP_Error,"SST_Terminate", 
		                                          "SST_Ext_ATP_UtilitySize",TST_MasterTestName);											
  
    if (EXT_TST_TestStatus!=TST_PASS)
       goto EXIT;

    /*open files and get files handle*/
	#ifndef DX_NVS_RAM

		EXT_TST_TestStatus =DX_VOS_FClose(TST_Ext_MainDBFileHandle);
		if (EXT_TST_TestStatus == DX_FAILURE)
        {
			 DX_VOS_Printf("CANT CLOSE MAIN FILE \n");
			goto EXIT;
        }
        
		EXT_TST_TestStatus = DX_VOS_FOpen(&TST_Ext_MainDBFileHandle,SST_DB_FILENAME ,"w+b");
        if (EXT_TST_TestStatus == DX_FAILURE)
        {
			DX_VOS_Printf("CANT OPEN MAIN FILE \n");
			goto EXIT;
        }

        EXT_TST_TestStatus =DX_VOS_FClose(TST_Ext_SecondaryDBFileHandle);
        if (EXT_TST_TestStatus == DX_FAILURE)
        {
		    DX_VOS_Printf("CANT CLOSE SECONDARY FILE \n");
			goto EXIT;
        }

        EXT_TST_TestStatus = DX_VOS_FOpen(&TST_Ext_SecondaryDBFileHandle,SST_DB_FILENAME_SECOND ,"w+b");
        if (EXT_TST_TestStatus == DX_FAILURE)
        {
			DX_VOS_Printf("CANT OPEN SECONDARY FILE \n");
			goto EXIT;
        }
		#else
			DX_VOS_MemSetZero(TST_Ext_MainDBPool,NVS_MEMORY_DATA_POOL_SIZE_IN_BYTES);
			DX_VOS_MemSetZero(TST_Ext_SecondaryDBPool,NVS_MEMORY_DATA_POOL_SIZE_IN_BYTES);
          
	#endif

	/* Init the SST for operations */
	/*-----------------------------*/
	EXT_TST_ATP_Error = SST_Init((DxNvsMemoryId_t)TST_Ext_MainDBFileHandle,
                                (DxNvsMemoryId_t)TST_Ext_SecondaryDBFileHandle,
                                &aInitInfo,
                   				TST_Ext_Workspace,
                   				TST_Ext_WorkspaceSizeInBytes);

     EXT_TST_TestStatus = TST_ATP_CheckErrorReturn(EXT_TST_ATP_Error,"SST_Init", 
		                                          "SST_Ext_ATP_UtilitySize",TST_MasterTestName);											
   
    if (EXT_TST_TestStatus!=TST_PASS)
       goto EXIT;
    
    
  
    EXT_TST_ATP_Error =  SST_UtilNVSSizesGet((DxNvsMemoryId_t)TST_Ext_MainDBFileHandle,
                                    &TST_maxSizeInBytesMain,
                                    &TST_CurrUsedSizeInBytesMain);
    
    
     EXT_TST_TestStatus = TST_ATP_CheckErrorReturn(EXT_TST_ATP_Error,"5.  SST_UtilNVSSizesGet - TST_MainDBFileHandle", 
		                                          "SST_Ext_ATP_UtilitySize",TST_MasterTestName);											
   
    if (EXT_TST_TestStatus!=TST_PASS)
       goto EXIT;

    
  
    EXT_TST_ATP_Error =SST_UtilNVSSizesGet((DxNvsMemoryId_t)TST_Ext_SecondaryDBFileHandle,
                                    &TST_maxSizeInBytesTxn,
                                    &TST_CurrUsedSizeInBytesTxnLast);
       
     EXT_TST_TestStatus = TST_ATP_CheckErrorReturn(EXT_TST_ATP_Error,"6.  SST_UtilNVSSizesGet - TST_SecondaryDBFileHandle", 
		                                          "SST_Ext_ATP_UtilitySize",TST_MasterTestName);											
   
    if (EXT_TST_TestStatus!=TST_PASS)
       goto EXIT;
   
     
       
	EXT_TST_ATP_Error = HOSTQA_ATP_Message(DX_SEP_HOST_SEP_PROTOCOL_SST_Utility_Size_OP_CODE,sizeof(Ext_ATP_DataOpTestDataStruct),SEP_ATP_DataOpTestData);
													 
	EXT_TST_TestStatus = TST_ATP_CheckErrorReturn(EXT_TST_ATP_Error,"SST_Ext_ATP_UtilitySize", 
		                                           "HOSTQA_ATP_Message",TST_MasterTestName);											
    
    
    EXIT:
		  return EXT_TST_TestStatus;												                        
 }
 
 
 
 
 
    
#endif
